#ifndef GLOBAL_H
#define GLOBAL_H

//#include "function.h"
#include "tools.h"
#include <stack.h>

typedef void dom(RTBox) ;
typedef dom* Pdom ;

typedef double obj(RCRVector) ;
typedef obj* Pobj ;

typedef void grad(RCRVector,RCRVector) ;
typedef grad* Pgrad ;

class GlobalParams {
public:
  long int maxtime;
  double eps_cl, mu, rshift;
  int det_pnts, rnd_pnts;
};

class Global: GlobalParams {
public:
  // Problem specification
  int dim ;
  Pobj  Objective ;
  Pgrad Gradient ;

  Global(RTBox, Pobj, Pgrad, GlobalParams);
  Global& operator=(const Global &);

  void Search(int, RCRVector);
  void DispMinimizers();
  bool NoMinimizers();
  void SetDomain(RTBox);
  void GetDomain(RTBox);
  double GetMinValue();
  void SetMinValue(double);
  void ClearSolSet();
  void AddPoint(RCRVector, double);

  long int GetTime();
  bool InTime();

private:
  list<Trial> SolSet;
  list<Trial>::const_iterator titr;
  priority_queue<TBox> CandSet;
  priority_queue<TBox> Garbage;

  double fbound;
  TBox Domain;

  void FillRegular(RTBox, RTBox);
  void FillRandom(RTBox, RTBox);
  double NewtonTest(RTBox, int, RCRVector, int*);
  void ReduceOrSubdivide(RTBox, int, RCRVector);
};
#endif

