/************************************************************************
*  Vector.h (Definition of type VECTOR)
*
*  Version:                     1.16
*  Date:                        1/26/94
*  Author:                      O. Knueppel
*************************************************************************/

#ifndef __VECTOR__
#define __VECTOR__

#include "Portab.h"
#include "config.h"
#include "error.h"
#include <iostream.h>

class VECTOR {
  INT nElements;
#ifdef __DONTCOPY__
  INT IsTemporary;
#endif
public:
  PREAL theElements;
  VECTOR ()
    {
#ifdef __DONTCOPY__
      IsTemporary = 0;
#endif
      nElements = 0; theElements = NULL; }
  VECTOR (INT n)
    {
#ifdef __DONTCOPY__
      IsTemporary = 0;
#endif
      CheckVectorRange (n);
      nElements = n;
      theElements = new REAL[n];
      CheckMemory (theElements);
    }
  ~VECTOR ()
    { if (theElements != NULL) delete theElements; }
  VECTOR (const VECTOR &);
  REAL & operator () (INT i) const 
    { CheckVectorIndex (i, *this); return theElements[i-1]; }
  VECTOR & operator =  (const VECTOR &);
  VECTOR & operator += (const VECTOR &);
  VECTOR & operator -= (const VECTOR &);
  VECTOR & operator *= (REAL);
  VECTOR & operator /= (REAL);
  friend INT Dimension (const VECTOR & x) { return x.nElements; }
  friend VOID Resize (VECTOR &, INT);
#ifdef __DONTCOPY__
  friend VOID MakeTemporary (VECTOR & x) { x.IsTemporary = 1; }
  friend VOID MakePermanent (VECTOR & x) { x.IsTemporary = 0; }
#else
  friend VOID MakeTemporary (VECTOR & x) { }
  friend VOID MakePermanent (VECTOR & x) { }
#endif
  friend VOID Clear (VECTOR &);
  friend VOID Initialize (VECTOR &, REAL);
  friend VECTOR operator + (const VECTOR & a) { return a; }
  friend VECTOR operator - (const VECTOR &);
  friend VECTOR operator + (const VECTOR &, const VECTOR &);
  friend VECTOR operator - (const VECTOR &, const VECTOR &);
  friend VECTOR operator * (REAL    , const VECTOR &);
  friend VECTOR operator / (const VECTOR &, REAL    );
  friend REAL   operator * (const VECTOR &, const VECTOR &);
  friend INT    operator <  (const VECTOR &, const VECTOR &);
  friend INT    operator <= (const VECTOR &, const VECTOR &);
  friend INT    operator >  (const VECTOR &, const VECTOR &);
  friend INT    operator >= (const VECTOR &, const VECTOR &);
  friend VECTOR Abs  (const VECTOR &);
  friend REAL   Sqr  (const VECTOR &);
  friend REAL   Norm (const VECTOR &);
  friend REAL   Max  (const VECTOR &);
  friend REAL   Min  (const VECTOR &);
  friend ostream & operator << (ostream &, const VECTOR &);
  friend istream & operator >> (istream &, VECTOR &);
};

#endif /* __VECTOR__ */

