
/* begin patch

#include "Bias0.h"
#include "Bias0.c"
#include "Bias1.h"
#include "Bias1.c"
#include "Bias2.h"
#include "Bias2.c"
#include "BiasF.h"
#include "BiasF.c"

/* end patch */

#include "lss.h"

#define DIMENSION 10 /* (DIMENSION+1) must be a prime number */

INT Legendre(INT a, INT p)
{
  INT s, i;

  s = a;
  for (i = 2; i <= (p-1) / 2; i++) { s *= a; s %= p; }
  if (s == p - 1) return (-1);
  else return s;
}
 
VOID InitData (INTERVAL_MATRIX & A, INTERVAL_VECTOR & b)
{
  int i, j, k;

  INT dim = Dimension (b);
  MATRIX Ar (dim, dim);
  VECTOR br (dim);
  INTERVAL erel(1.0, 1.0);

  Clear (Ar);
  for (k = 2; k <= 2*dim; k++)
    for (i = max(1,k-dim); i <= min(dim,k-1); i++)
      {
	j = k - i;
	Ar(j,i) = Ar(i,j) = Legendre(i+j, dim+1);
      }

  VECTOR x (dim);

  REAL s = 1.0;
  for (i = 1; i <= dim; i++)
    {
      x(i) = s / (REAL) i;
      s = -s;
    }

  br = Ar*x;

  A = erel * Ar;
  b = erel * br;
}

VOID TestILSS (VOID)
{
  INT i;
  INTERVAL_MATRIX A (DIMENSION, DIMENSION);
  INTERVAL_VECTOR b (DIMENSION);
  INTERVAL_VECTOR X (DIMENSION);
  INT done = 0;

  InitData (A, b);

  X = ILSS (A, b, done);
#if 1
  cout << "The following output should be enclosures of (-1)^(i+1) * (1/i)," << endl;
  cout << "with i = 1.." << DIMENSION << ":" << endl << endl;
  cout.precision (16);
  for (i = 1; i <= DIMENSION; i++) cout << X(i) << endl;
#endif
}

INT main()
{
  TestILSS ();
  return 0;
}

