/************************************************************************
*  RealOp.h (Definition of commonly used real operations)
*
*  Version:                     1.1
*  Date:                        6/30/93
*  Author:                      O. Knueppel
*************************************************************************/

#ifndef __REALOP__
#define __REALOP__

#include "Portab.h"
#include "config.h"

#if defined (__cplusplus)
extern "C" {
#endif

VOID RealOpNeg (PREAL pr, PCREAL pa, INT dim);

VOID RealOpAdd (PREAL pr, PCREAL pa, PCREAL pb, INT dim);
VOID RealOpSub (PREAL pr, PCREAL pa, PCREAL pb, INT dim);
VOID RealOpMul (PREAL pr, REAL  a,  PCREAL pb, INT dim);
VOID RealOpDiv (PREAL pr, PCREAL pa, REAL  b,  INT dim);

VOID RealOpAddTo   (PREAL pr, PCREAL pa, INT dim);
VOID RealOpSubFrom (PREAL pr, PCREAL pa, INT dim);
VOID RealOpMulWith (PREAL pr, REAL  a,  INT dim);
VOID RealOpDivBy   (PREAL pr, REAL  a,  INT dim);

REAL RealOpScalp (PCREAL pa, PCREAL pb, INT dim);

VOID RealOpVecMul (PREAL pr, PCREAL pa, const PCREAL pb, INT rows, INT cols);
VOID RealOpMatMul (PREAL pr, PCREAL pa, PCREAL pb,
		   INT arows, INT acols, INT bcols);

INT RealOpLessThan     (PCREAL pa, PCREAL pb, INT dim);
INT RealOpLessEqual    (PCREAL pa, PCREAL pb, INT dim);
INT RealOpGreaterThan  (PCREAL pa, PCREAL pb, INT dim);
INT RealOpGreaterEqual (PCREAL pa, PCREAL pb, INT dim);

#if defined (__cplusplus)
}
#endif

#endif /* __REALOP__ */

