/************************************************************************
*  IntervalVector.h (Definition of type INTERVAL_VECTOR)
*
*  Version:                     1.17
*  Date:                        1/30/95
*  Author:                      O. Knueppel
*************************************************************************/

#ifndef __INTERVAL_VECTOR__
#define __INTERVAL_VECTOR__

#include "Bias1.h"
#include "error.h"
#include "vector.h"
#include "ival.h"
#include <memory.h>

class INTERVAL_VECTOR {
  INT nElements;
#ifdef __DONTCOPY__
  INT IsTemporary;
#endif
public:
  PBIASINTERVAL theElements;
  INTERVAL_VECTOR ()
    {
#ifdef __DONTCOPY__
      IsTemporary = 0;
#endif
      nElements = 0; theElements = NULL; }
  INTERVAL_VECTOR (INT n)
    {
#ifdef __DONTCOPY__
      IsTemporary = 0;
#endif
      CheckVectorRange (n);
      nElements = n;
      theElements = new BIASINTERVAL[n];
      CheckMemory (theElements);
    }
  ~INTERVAL_VECTOR ()
    { if (theElements != NULL) delete theElements; }
  INTERVAL_VECTOR (const INTERVAL_VECTOR &);
  INTERVAL & operator () (INT i) const 
    { CheckVectorIndex (i, *this); return * ((INTERVAL *)(theElements + i-1)); }
  INTERVAL_VECTOR & operator =  (const INTERVAL_VECTOR &);
  INTERVAL_VECTOR & operator =  (const VECTOR &);
  INTERVAL_VECTOR & operator += (const INTERVAL_VECTOR &);
  INTERVAL_VECTOR & operator -= (const INTERVAL_VECTOR &);
  INTERVAL_VECTOR & operator *= (const INTERVAL &);
  INTERVAL_VECTOR & operator /= (const INTERVAL &);
  INTERVAL_VECTOR & operator += (const VECTOR &);
  INTERVAL_VECTOR & operator -= (const VECTOR &);
  INTERVAL_VECTOR & operator *= (REAL);
  INTERVAL_VECTOR & operator /= (REAL);
  friend INT Dimension (const INTERVAL_VECTOR & x) { return x.nElements; }
  friend VOID Resize (INTERVAL_VECTOR &, INT);
#ifdef __DONTCOPY__
  friend VOID MakeTemporary (INTERVAL_VECTOR & x) { x.IsTemporary = 1; }
  friend VOID MakePermanent (INTERVAL_VECTOR & x) { x.IsTemporary = 0; }
#else
  friend VOID MakeTemporary (INTERVAL_VECTOR & x) { }
  friend VOID MakePermanent (INTERVAL_VECTOR & x) { }
#endif
  friend VOID Clear (INTERVAL_VECTOR &);
  friend VOID Initialize (INTERVAL_VECTOR &, const INTERVAL &);
  friend VECTOR Inf (const INTERVAL_VECTOR &);
  friend VECTOR Sup (const INTERVAL_VECTOR &);
  friend VECTOR Mid (const INTERVAL_VECTOR &);
  friend VECTOR Diam (const INTERVAL_VECTOR &);
  friend VECTOR Abs (const INTERVAL_VECTOR &);
  friend INT Intersection (INTERVAL_VECTOR &, const INTERVAL_VECTOR &, const INTERVAL_VECTOR &);
  friend INT operator <= (const VECTOR &, const INTERVAL_VECTOR &);
  friend INT operator <= (const INTERVAL_VECTOR &, const INTERVAL_VECTOR &);
  friend INT operator <  (const VECTOR &, const INTERVAL_VECTOR &);
  friend INT operator <  (const INTERVAL_VECTOR &, const INTERVAL_VECTOR &);
  friend INT operator == (const INTERVAL_VECTOR &, const INTERVAL_VECTOR &);
  friend INT operator != (const INTERVAL_VECTOR &, const INTERVAL_VECTOR &);
  friend INTERVAL_VECTOR Hull (const VECTOR &);
  friend INTERVAL_VECTOR Hull (const VECTOR &, const VECTOR &);
  friend INTERVAL_VECTOR Hull (const VECTOR &, const INTERVAL_VECTOR &);
  friend INTERVAL_VECTOR Hull (const INTERVAL_VECTOR &, const VECTOR &);
  friend INTERVAL_VECTOR Hull (const INTERVAL_VECTOR &, const INTERVAL_VECTOR &);
  friend INTERVAL_VECTOR SymHull (const VECTOR & x) { return Hull (-x, x); }
  friend INTERVAL_VECTOR operator + (const INTERVAL_VECTOR & a) { return a; }
  friend INTERVAL_VECTOR operator - (const INTERVAL_VECTOR &);
  friend INTERVAL_VECTOR operator + (const VECTOR &, const INTERVAL_VECTOR &);
  friend INTERVAL_VECTOR operator + (const INTERVAL_VECTOR &, const VECTOR &);
  friend INTERVAL_VECTOR operator + (const INTERVAL_VECTOR &, const INTERVAL_VECTOR &);
  friend INTERVAL_VECTOR AddBounds  (const VECTOR &, const VECTOR &);
  friend INTERVAL_VECTOR operator - (const VECTOR &, const INTERVAL_VECTOR &);
  friend INTERVAL_VECTOR operator - (const INTERVAL_VECTOR &, const VECTOR &);
  friend INTERVAL_VECTOR operator - (const INTERVAL_VECTOR &, const INTERVAL_VECTOR &);
  friend INTERVAL_VECTOR SubBounds  (const VECTOR &, const VECTOR &);
  friend INTERVAL_VECTOR operator * (REAL, const INTERVAL_VECTOR &);
  friend INTERVAL_VECTOR operator * (const INTERVAL &, const VECTOR &);
  friend INTERVAL_VECTOR operator * (const INTERVAL &, const INTERVAL_VECTOR &);
  friend INTERVAL_VECTOR MulBounds  (REAL, const VECTOR &);
  friend INTERVAL_VECTOR operator / (const INTERVAL_VECTOR &, REAL);
  friend INTERVAL_VECTOR operator / (const VECTOR &, const INTERVAL &);
  friend INTERVAL_VECTOR operator / (const INTERVAL_VECTOR &, const INTERVAL &);
  friend INTERVAL_VECTOR DivBounds  (const VECTOR &, REAL);
  friend INTERVAL operator * (const VECTOR &, const INTERVAL_VECTOR &);
  friend INTERVAL operator * (const INTERVAL_VECTOR &, const VECTOR &);
  friend INTERVAL operator * (const INTERVAL_VECTOR &, const INTERVAL_VECTOR &);
  friend INTERVAL MulBounds  (const VECTOR &, const VECTOR &);
  friend INTERVAL Sqr  (const INTERVAL_VECTOR &);
  friend INTERVAL Norm (const INTERVAL_VECTOR &);
  friend ostream & operator << (ostream &, const INTERVAL_VECTOR &);
  friend istream & operator >> (istream &, INTERVAL_VECTOR &);
};

#endif /* __INTERVAL_VECTOR__ */

