/************************************************************************
*  Functions.h (Definition of standard functions (REAL and INTERVAL))
*
*  Version:                     1.9
*  Date:                        9/27/93
*  Author:                      O. Knueppel
*************************************************************************/

#ifndef __FUNCTIONS__
#define __FUNCTIONS__

#include "Ival.h"
#include "BiasF.h"
#include <math.h>

class Constant {
public:
  static REAL Pi;
  static REAL TwoPi;
  static REAL PiHalf;
  static REAL PiQuarter;
  static REAL e;
  static REAL Sqrt2;
  static REAL InvSqrt2;
  static REAL Ln10;
  Constant ();
  ~Constant () { }
};

inline REAL Sin    (REAL x) { return sin(x); }
inline REAL Cos    (REAL x) { return cos(x); }
inline REAL Tan    (REAL x) { return tan(x); }
inline REAL Cot    (REAL x) { return -tan(x + Constant::PiHalf); }
inline REAL ArcSin (REAL x) { return asin(x); }
inline REAL ArcCos (REAL x) { return acos(x); }
inline REAL ArcTan (REAL x) { return atan(x); }
inline REAL ArcCot (REAL x) { return atan(-x) + Constant::PiHalf; }

inline REAL Sinh   (REAL x) { return sinh(x); }
inline REAL Cosh   (REAL x) { return cosh(x); }
inline REAL Tanh   (REAL x) { return tanh(x); }
inline REAL Coth   (REAL x) { return 1.0 / tanh(x); }
       REAL ArSinh (REAL x);
       REAL ArCosh (REAL x);
       REAL ArTanh (REAL x);
       REAL ArCoth (REAL x);

inline REAL Exp    (REAL x) { return exp(x); }
inline REAL Log    (REAL x) { return log(x); }
inline REAL Log10  (REAL x) { return log10(x); }

inline REAL Abs    (REAL x) { return fabs(x); }
inline REAL Sqr    (REAL x) { return x*x; }
inline REAL Sqrt   (REAL x) { return sqrt(x); }
inline REAL Root   (REAL x, INT n) { return pow(x, 1.0 / (REAL) n); }

       REAL Power  (REAL x, INT n);
inline REAL Power  (REAL x, REAL y) { return pow(x, y); }

inline REAL Min    (REAL x, REAL y) { return (x < y) ? x : y; }
inline REAL Max    (REAL x, REAL y) { return (x > y) ? x : y; }

       INTERVAL Sin    (const INTERVAL & x);
       INTERVAL Cos    (const INTERVAL & x);
       INTERVAL Tan    (const INTERVAL & x);
       INTERVAL Cot    (const INTERVAL & x);
       INTERVAL ArcSin (const INTERVAL & x);
       INTERVAL ArcCos (const INTERVAL & x);
       INTERVAL ArcTan (const INTERVAL & x);
       INTERVAL ArcCot (const INTERVAL & x);

       INTERVAL Sinh   (const INTERVAL & x);
       INTERVAL Cosh   (const INTERVAL & x);
       INTERVAL Tanh   (const INTERVAL & x);
       INTERVAL Coth   (const INTERVAL & x);
       INTERVAL ArSinh (const INTERVAL & x);
       INTERVAL ArCosh (const INTERVAL & x);
       INTERVAL ArTanh (const INTERVAL & x);
       INTERVAL ArCoth (const INTERVAL & x);

       INTERVAL Exp    (const INTERVAL & x);
       INTERVAL Log    (const INTERVAL & x);
       INTERVAL Log10  (const INTERVAL & x);

       INTERVAL IAbs   (const INTERVAL & x);
       INTERVAL Sqr    (const INTERVAL & x);
       INTERVAL Sqrt   (const INTERVAL & x);
       INTERVAL Root   (const INTERVAL & x, INT n);

       INTERVAL Power  (const INTERVAL & x, INT n);
       INTERVAL Power  (const INTERVAL & x, const INTERVAL & y);

#endif /* __FUNCTIONS__ */

