#include "ival.h"
#include "func.h"
#include "setclass.cpp"


INTERVAL F( INTERVAL X )
{
    return(  Sin(X) + Cos(X)  );
} 

main()
{ 
  INTERVAL X, FX, X1, FX1, X2, FX2;
  REAL m, FX_lower;
  CandidateSet Storage1, Storage2;

  X  = Hull(-0.5, 1.0);  FX = F(X); 
  
  Storage1.Insert( X, Inf(FX) );
  Storage2.Insert( X, Inf(FX) );
   
  cout << " Printout 1 (Storage2): "  << endl
       << Storage2;
       
  m   = Mid(X); 
  X1  = Hull( Inf(X), m ); FX1 = F(X1); 
  X2  = Hull( m, Sup(X) ); FX2 = F(X2); 
  
  cout << " Printout 2."                     << endl
       << " X , FX : " << X  << "   " << FX  << endl 
       << " X1, FX1: " << X1 << "   " << FX1 << endl 
       << " X2, FX2: " << X2 << "   " << FX2 << endl 
       << endl ;

  Storage1.Insert( X1, Inf(FX1) );
  Storage1.Insert( X2, Inf(FX2) );
  
  if ( Storage1.notEmpty() )     // "if ( X.notEmpty() )" is 
  				 // disposable here but should in
                                 // principle always be applied before 
                                 // a statement which uses elements 
                                 // from the set X.
  {
             FX_lower = Storage1.BestInfF();
             X = Storage1.BestX();
    
             cout << " Printout 3."  << endl
                  << "X = " << X   << "   FX_lower = " << FX_lower << endl
                  << " Storage1: " << Storage1 ;
 
             Storage1.RemoveBest();
  
             cout << " Printout 4 (Storage1): "  << endl
             << Storage1;
   }
   else      cout << " Storage1 is empty " << endl;

  Storage1.Reduce( 0.5 );
    
  cout << " Printout 5 (Storage1): "  << endl
       << Storage1;

}
