#include "ival.h"
#include "const.h"

class Node {
public:
  Node( INTERVAL X, REAL InfFX )
  { XI = X; InfFXI = InfFX; Next = NULL; }

  INTERVAL X() const
  { return XI; }

  REAL InfFX() const
  { return InfFXI; }

  Node *next()
  { return Next; }

  VOID link( Node *p )
  { Next = p; }

private:
  INTERVAL XI;
  REAL InfFXI;
  Node *Next;
};

class CandidateSet {
public:

  CandidateSet()
  {     
    LastInList = new Node( Hull(Machine::NaN), Machine::PosInfinity);
    Head = LastInList;
  }

  Node *Best()
  { return Head; }

  INTERVAL BestX()
  { return Head->X(); }

  REAL BestInfF()
  { return Head->InfFX(); }

  VOID RemoveBest()
  { 
    Node *p = Head;
    Head = Head->next();
    delete p;
  }

  INT Length()
  { 
    INT n = 0;
    Node *p;
    p = Head;
    while ( p != LastInList ){
      n = n + 1;
      p = p->next();
    }
    return n;
  }

  friend  ostream & operator << ( ostream & os, CandidateSet & s)
  { 
    Node *p;
    INT n = 0;
    p = s.Best();
    os << "Candidate set : ";
    while ( p != s.LastInList ){
      os  << endl << p->X() << "\t " << p->InfFX();
      n = n + 1;
      p = p->next();
    }
    if ( n == 0 ) 
      os << " Empty. " << endl << endl ;
    else
      os << endl << "Length = " << n << endl << endl ;
    return os;
  }  

  VOID Insert( INTERVAL X, REAL InfFX )
  { 
    Node *n = new Node(X, InfFX),
         *p, *before_p;
    p = Head; before_p = Head;
    while ( p->InfFX() < n->InfFX() ){
      before_p = p;
      p = p->next();
    }
    if ( p == Head ) 
      Head = n;
    else
      before_p->link(n);
    n->link(p);
  }

  VOID Reduce( REAL f_value )
  { 
    Node *p, *before_p, *tail, *before_tail;
    p = Head; before_p = Head;
    while ( p->InfFX() <= f_value ){
      before_p = p;
      p = p->next();
    }
    tail = p; before_tail = p;
    while ( tail != LastInList  ){
      before_tail = tail;
      tail = tail->next();
      delete before_tail; 
    }
    if ( p == Head )
      Head = tail;
    else
      before_p->link(tail);
  }

  BOOL notEmpty() const
  { return  Head != LastInList; }

private:

  Node *Head;
  Node *LastInList;
};


