/************************************************************************
*  BiasF.h (Basic Interval Arithmetic Subroutines Standard Functions)
*
*  Version:                     1.4
*  Date:                        9/29/93
*  Author:                      O. Knueppel
*  Interval Representation:     any
*  Interval Implementation:     any
*************************************************************************/

#ifndef __BIASF__
#define __BIASF__

#include "Bias0.h"

/************************************************************************
*  Definition of Constants, Types, and Variables
*************************************************************************/

#if defined (__cplusplus)
#define extern extern "C"
#endif

extern REAL     BiasPi;                 /* 3.141...                     */
extern REAL     BiasTwoPi;
extern REAL     BiasPiHalf;
extern REAL     BiasPiQuarter;
extern REAL     BiasE;
extern REAL     BiasSqrt2;
extern REAL     BiasInvSqrt2;           /* 1/ Sqrt(2)                   */
extern REAL     BiasLn10;
#undef extern

/************************************************************************
*  Function Prototypes
*************************************************************************/

#if defined (__cplusplus)
extern "C" {
#endif

VOID    BiasFuncInit    (VOID);

VOID    BiasSin    (const PBIASINTERVAL, const PCBIASINTERVAL);
VOID    BiasCos    (const PBIASINTERVAL, const PCBIASINTERVAL);
VOID    BiasTan    (const PBIASINTERVAL, const PCBIASINTERVAL);
VOID    BiasCot    (const PBIASINTERVAL, const PCBIASINTERVAL);

VOID    BiasArcSin (const PBIASINTERVAL, const PCBIASINTERVAL);
VOID    BiasArcCos (const PBIASINTERVAL, const PCBIASINTERVAL);
VOID    BiasArcTan (const PBIASINTERVAL, const PCBIASINTERVAL);
VOID    BiasArcCot (const PBIASINTERVAL, const PCBIASINTERVAL);

VOID    BiasSinh   (const PBIASINTERVAL, const PCBIASINTERVAL);
VOID    BiasCosh   (const PBIASINTERVAL, const PCBIASINTERVAL);
VOID    BiasTanh   (const PBIASINTERVAL, const PCBIASINTERVAL);
VOID    BiasCoth   (const PBIASINTERVAL, const PCBIASINTERVAL);

VOID    BiasArSinh (const PBIASINTERVAL, const PCBIASINTERVAL);
VOID    BiasArCosh (const PBIASINTERVAL, const PCBIASINTERVAL);
VOID    BiasArTanh (const PBIASINTERVAL, const PCBIASINTERVAL);
VOID    BiasArCoth (const PBIASINTERVAL, const PCBIASINTERVAL);

VOID    BiasExp    (const PBIASINTERVAL, const PCBIASINTERVAL);
VOID    BiasLog    (const PBIASINTERVAL, const PCBIASINTERVAL);
VOID    BiasLog10  (const PBIASINTERVAL, const PCBIASINTERVAL);

VOID    BiasIAbs   (const PBIASINTERVAL, const PCBIASINTERVAL);
VOID    BiasSqr    (const PBIASINTERVAL, const PCBIASINTERVAL);
VOID    BiasSqrt   (const PBIASINTERVAL, const PCBIASINTERVAL);
VOID    BiasRoot   (const PBIASINTERVAL, const PCBIASINTERVAL, const INT);

VOID    BiasPowerN (const PBIASINTERVAL, const PCBIASINTERVAL, const INT);
VOID    BiasPowerI (const PBIASINTERVAL, const PCBIASINTERVAL, const PCBIASINTERVAL);

#if defined (__cplusplus)
}
#endif

#endif /* __BIASF__ */
