/************************************************************************
*  Bias2IEEE.h (Basic Interval Arithmetic Subroutines Level 2)
*
*  Version:                     1.3
*  Date:                        10/1/93
*  Author:                      O. Knueppel
*  Interval Representation:     INFSUP
*  Interval Implementation:     IEEE
*************************************************************************/

#ifndef __BIAS2__
#define __BIAS2__

#ifndef __BIAS0__
#include "Bias0.h"
#endif

#ifndef __BIAS1__
#include "Bias1.h"
#endif

/* #define __BIAS2USEVECTOROPERATIONS__ */

/************************************************************************
*  Function Prototypes
*************************************************************************/

#if defined (__cplusplus)
extern "C" {
#endif

VOID    BiasMulRMR      (PBIASINTERVAL pR, PCREAL         pa, PCREAL         pb,
			 const INT rows, const INT cols);
VOID    BiasMulRMI      (PBIASINTERVAL pR, PCREAL         pa, PCBIASINTERVAL pB,
			 const INT rows, const INT cols);
VOID    BiasMulIMR      (PBIASINTERVAL pR, PCBIASINTERVAL pA, PCREAL         pb,
			 const INT rows, const INT cols);
VOID    BiasMulIMI      (PBIASINTERVAL pR, PCBIASINTERVAL pA, PCBIASINTERVAL pB,
			 const INT rows, const INT cols);

VOID    BiasDivMRR      (PBIASINTERVAL pR, PCREAL         pa, PCREAL         pb,
			 const INT rows, const INT cols);
VOID    BiasDivMRI      (PBIASINTERVAL pR, PCREAL         pa, PCBIASINTERVAL pB,
			 const INT rows, const INT cols);
VOID    BiasDivMIR      (PBIASINTERVAL pR, PCBIASINTERVAL pA, PCREAL         pb,
			 const INT rows, const INT cols);
VOID    BiasDivMII      (PBIASINTERVAL pR, PCBIASINTERVAL pA, PCBIASINTERVAL pB,
			 const INT rows, const INT cols);

VOID    BiasMulMRVR     (PBIASINTERVAL pR, PCREAL         pa, PCREAL         pb,
			 const INT rows, const INT cols);
VOID    BiasMulMRVI     (PBIASINTERVAL pR, PCREAL         pa, PCBIASINTERVAL pB,
			 const INT rows, const INT cols);
VOID    BiasMulMIVR     (PBIASINTERVAL pR, PCBIASINTERVAL pA, PCREAL         pb,
			 const INT rows, const INT cols);
VOID    BiasMulMIVI     (PBIASINTERVAL pR, PCBIASINTERVAL pA, PCBIASINTERVAL pB,
			 const INT rows, const INT cols);

#if defined (__BIAS2USEVECTOROPERATIONS__)
#define BiasAddMRMR(pR, pa, pb, r, c)      BiasAddVRVR (pR, pa, pb, (r)*(c))
#define BiasAddMRMI(pR, pa, pB, r, c)      BiasAddVRVI (pR, pa, pB, (r)*(c))
#define BiasAddMIMR(pR, pA, pb, r, c)      BiasAddVIVR (pR, pA, pb, (r)*(c))
#define BiasAddMIMI(pR, pA, pB, r, c)      BiasAddVIVI (pR, pA, pB, (r)*(c))
#define BiasSubMRMR(pR, pa, pb, r, c)      BiasSubVRVR (pR, pa, pb, (r)*(c))
#define BiasSubMRMI(pR, pa, pB, r, c)      BiasSubVRVI (pR, pa, pB, (r)*(c))
#define BiasSubMIMR(pR, pA, pb, r, c)      BiasSubVIVR (pR, pA, pb, (r)*(c))
#define BiasSubMIMI(pR, pA, pB, r, c)      BiasSubVIVI (pR, pA, pB, (r)*(c))
#else

VOID    BiasAddMRMR     (const PBIASINTERVAL pR, const PCREAL pa, const PCREAL pb,
			 const INT rows, const INT cols);
VOID    BiasAddMRMI     (PBIASINTERVAL pR, PCREAL         pa, PCBIASINTERVAL pB,
			 const INT rows, const INT cols);
#define BiasAddMIMR(pR, pA, pb, r, c)      BiasAddMRMI (pR, pb, pA, r, c)
VOID    BiasAddMIMI     (PBIASINTERVAL pR, PCBIASINTERVAL pA, PCBIASINTERVAL pB,
			 const INT rows, const INT cols);

VOID    BiasSubMRMR     (PBIASINTERVAL pR, PCREAL         pa, PCREAL         pb,
			 const INT rows, const INT cols);
VOID    BiasSubMRMI     (PBIASINTERVAL pR, PCREAL         pa, PCBIASINTERVAL pB,
			 const INT rows, const INT cols);
VOID    BiasSubMIMR     (PBIASINTERVAL pR, PCBIASINTERVAL pA, PCREAL         pb,
			 const INT rows, const INT cols);
VOID    BiasSubMIMI     (PBIASINTERVAL pR, PCBIASINTERVAL pA, PCBIASINTERVAL pB,
			 const INT rows, const INT cols);
#endif

VOID    BiasMulMRMR     (PBIASINTERVAL pR, PCREAL         pa, const PCREAL         pb,
			 const INT arows, const INT acols, const INT bcols);
VOID    BiasMulMRMI     (PBIASINTERVAL pR, PCREAL         pa, const PCBIASINTERVAL pB,
			 const INT arows, const INT acols, const INT Bcols);
VOID    BiasMulMIMR     (PBIASINTERVAL pR, const PCBIASINTERVAL pA, PCREAL         pb,
                         const INT Arows, const INT Acols, const INT bcols);

VOID    BiasMulMIMI     (PBIASINTERVAL pR, PCBIASINTERVAL pA, PCBIASINTERVAL pB,
			 const INT Arows, const INT Acols, const INT Bcols);

#define BiasPredMR(pr, pa, r, c)           BiasPredVR (pr, pa, (r)*(c))
#define BiasPredMI(pR, pA, r, c)           BiasPredVI (pR, pA, (r)*(c))
#define BiasSuccMR(pr, pa, r, c)           BiasSuccVR (pr, pa, (r)*(c))
#define BiasSuccMI(pR, pA, r, c)           BiasSuccVI (pR, pA, (r)*(c))

#define BiasInfM(pr, pA, r, c)             BiasInfV (pr, pA, (r)*(c))
#define BiasSupM(pr, pA, r, c)             BiasSupV (pr, pA, (r)*(c))

#define BiasNegM(pR, pA, r, c)             BiasNegV (pR, pA, (r)*(c))

#define BiasMidM(pr, pA, r, c)             BiasMidV (pr, pA, (r)*(c))
#define BiasMidRadM(pm, pr, pA, r, c)      BiasMidRadV (pm, pr, pA, (r)*(c))

#define BiasDiamM(pr, pA, r, c)            BiasDiamV (pr, pA, (r)*(c))

#define BiasAbsM(pr, pA, r, c)             BiasAbsV (pr, pA, (r)*(c))

#define BiasIntersectionM(pR, pA, pB, r, c)   BiasIntersectionV (pR, pA, pB, (r)*(c))

#define BiasHullMR(pR, pa, r, c)           BiasHullVR (pR, pa, (r)*(c))
#define BiasHullMRMR(pR, pa, pb, r, c)     BiasHullVRVR (pR, pa, pb, (r)*(c))
#define BiasHullMRMI(pR, pa, pB, r, c)     BiasHullVRVI (pR, pa, pB, (r)*(c))
#define BiasHullMIMR(pR, pA, pb, r, c)     BiasHullVIVR (pR, pA, pb, (r)*(c))
#define BiasHullMIMI(pR, pA, pB, r, c)     BiasHullVIVI (pR, pA, pB, (r)*(c))

#define BiasInMR(pa, pB, r, c)             BiasInVR (pa, pB, (r)*(c))
#define BiasInMI(pA, pB, r, c)             BiasInVI (pA, pB, (r)*(c))

#define BiasInInteriorMR(pa, pB, r, c)     BiasInInteriorVR (pa, pB, (r)*(c))
#define BiasInInteriorMI(pA, pB, r, c)     BiasInInteriorVI (pA, pB, (r)*(c))

#define BiasIsEqualM(pA, pB, r, c)         BiasIsEqualV (pA, pB, (r)*(c))

#define BiasSetToZeroM(pR, r, c)           BiasSetToZeroV (pR, (r)*(c))

#if defined (__cplusplus)
}
#endif

#endif /* __BIAS2__ */
