/************************************************************************
*  Bias1IEEE.h (Basic Interval Arithmetic Subroutines Level 1)
*
*  Version:                     1.6
*  Date:                        10/1/93
*  Author:                      O. Knueppel
*  Interval Representation:     INFSUP
*  Interval Implementation:     IEEE
*************************************************************************/

#ifndef __BIAS1__
#define __BIAS1__

#ifndef __BIAS0__
#include "Bias0.h"
#endif

/************************************************************************
*  Function Prototypes
*************************************************************************/

#if defined (__cplusplus)
extern "C" {
#endif

VOID    BiasPredVR      (      PREAL         pr,
			       PCREAL         pa, const INT dim);
INT     BiasPredVI      (      const PBIASINTERVAL pR,
			       const PCBIASINTERVAL pA, const INT dim);

VOID    BiasSuccVR      (      PREAL         pr,
			       PCREAL         pa, const INT dim);
VOID    BiasSuccVI      (      const PBIASINTERVAL pR,
			       const PCBIASINTERVAL pA, const INT dim);

VOID    BiasAddVRVR     (const PBIASINTERVAL pR, const PCREAL         pa,
			 const PCREAL         pb, const INT dim);
VOID    BiasAddVRVI     (const PBIASINTERVAL pR, const PCREAL         pa,
			 const PCBIASINTERVAL pB, const INT dim);
VOID    BiasAddVIVI     (const PBIASINTERVAL pR, const PCBIASINTERVAL pa,
			 const PCBIASINTERVAL pB, const INT dim);

VOID    BiasSubVRVR     (const PBIASINTERVAL pR, const PCREAL         pa,
			 const PCREAL         pb, const INT dim);
VOID    BiasSubVRVI     (const PBIASINTERVAL pR, const PCREAL         pa,
			 const PCBIASINTERVAL pB, const INT dim);
VOID    BiasSubVIVR     (const PBIASINTERVAL pR, const PCBIASINTERVAL pA,
			 const PCREAL         pb, const INT dim);
VOID    BiasSubVIVI     (const PBIASINTERVAL pR, const PCBIASINTERVAL pa,
			 const PCBIASINTERVAL pB, const INT dim);

VOID    BiasMulRVR      (const PBIASINTERVAL pR, const PCREAL         pa,
			 const PCREAL         pb, const INT dim);
VOID    BiasMulIVR      (const PBIASINTERVAL pR, const PCBIASINTERVAL pA,
			 const PCREAL         pb, const INT dim);
VOID    BiasMulRVI      (const PBIASINTERVAL pR, const PCREAL         pa,
			 const PCBIASINTERVAL pB, const INT dim);
VOID    BiasMulIVI      (      PBIASINTERVAL pR, const PCBIASINTERVAL pa,
			       PCBIASINTERVAL pB, const INT dim);

VOID    BiasMacRVR      (const PBIASINTERVAL pR, const PCREAL         pa,
			 const PCREAL         pb, const INT dim);
VOID    BiasMacIVR      (const PBIASINTERVAL pR, const PCBIASINTERVAL pA,
			 const PCREAL         pb, const INT dim);
VOID    BiasMacRVI      (const PBIASINTERVAL pR, const PCREAL         pa,
			 const PCBIASINTERVAL pB, const INT dim);
VOID    BiasMacIVI      (      PBIASINTERVAL pR, const PCBIASINTERVAL pa,
			       PCBIASINTERVAL pB, const INT dim);

VOID    BiasMacRVIs     (const PBIASINTERVAL pR, const PCREAL         pa,
			 const PCBIASINTERVAL pB, const INT dim, const INT Bstep);
VOID    BiasMacsRVIs    (const PBIASINTERVAL pR,
			 const PCREAL         pa, const PCBIASINTERVAL pB,
			 const INT dim, const INT Rstep, const INT Bstep);

VOID    BiasDivVRR      (const PBIASINTERVAL pR, const PCREAL         pa,
			 const PCREAL         pb, const INT dim);
VOID    BiasDivVIR      (const PBIASINTERVAL pR, const PCBIASINTERVAL pA,
			 const PCREAL         pb, const INT dim);
VOID    BiasDivVRI      (const PBIASINTERVAL pR, const PCREAL         pa,
			 const PCBIASINTERVAL pB, const INT dim);
VOID    BiasDivVII      (      PBIASINTERVAL pR,       PCBIASINTERVAL pa,
			 const PCBIASINTERVAL pB, const INT dim);

VOID    BiasMacVRVR     (const PBIASINTERVAL pR, const PCREAL         pa,
			 const PCREAL         pb, const INT dim);
VOID    BiasMacVRVI     (const PBIASINTERVAL pR, const PCREAL         pa,
			 const PCBIASINTERVAL pB, const INT dim);
VOID    BiasMacVIVI     (const PBIASINTERVAL pR,       PCBIASINTERVAL pA,
			       PCBIASINTERVAL pB, const INT dim);

VOID    BiasInfV        (      PREAL         pr,       PCBIASINTERVAL pA, const INT dim);
VOID    BiasSupV        (      PREAL         pr,       PCBIASINTERVAL pA, const INT dim);

VOID    BiasNegV        (      PBIASINTERVAL pR,       PCBIASINTERVAL pA, const INT dim);

VOID    BiasMidV        (      PREAL         pr,       PCBIASINTERVAL pA, const INT dim);
VOID    BiasMidRadV     (      PREAL         pm,       PREAL         pr,
			       PCBIASINTERVAL pA, const INT dim);
VOID    BiasDiamV       (      PREAL         pr,
			       PCBIASINTERVAL pA, const INT dim);

VOID    BiasAbsV        (      PREAL         pr,
			       PCBIASINTERVAL pA, const INT dim);

INT     BiasIntersectionV (      PBIASINTERVAL pR,
			         PCBIASINTERVAL pA,       PCBIASINTERVAL pB, const INT dim);

VOID    BiasHullVR      (      PBIASINTERVAL pR,
			       PCREAL         pa, const INT dim);
VOID    BiasHullVRVR    (      PBIASINTERVAL pR,
			       PCREAL         pa,       PCREAL         pb, const INT dim);
VOID    BiasHullVRVI    (      PBIASINTERVAL pR,
			       PCREAL         pa,       PCBIASINTERVAL pB, const INT dim);
VOID    BiasHullVIVI    (      PBIASINTERVAL pR,
			       PCBIASINTERVAL pA,       PCBIASINTERVAL pB, const INT dim);

INT     BiasInVR        (      PCREAL         pa,       PCBIASINTERVAL pB, const INT dim);
INT     BiasInVI        (      PCBIASINTERVAL pA,       PCBIASINTERVAL pB, const INT dim);

INT     BiasInInteriorVR(      PCREAL         pa,       PCBIASINTERVAL pB, const INT dim);
INT     BiasInInteriorVI(      PCBIASINTERVAL pA,       PCBIASINTERVAL pB, const INT dim);

INT     BiasIsEqualV    (      PCBIASINTERVAL pA,       PCBIASINTERVAL pB, const INT dim);

VOID    BiasSetToZeroV  (const PBIASINTERVAL pR, const INT dim);
VOID    BiasSetToZeroVs (      PBIASINTERVAL pR, const INT dim, const INT step);

#define BiasAddVIVR(pR, pA, pb, d)   BiasAddVRVI (pR, pb, pA, d)
#define BiasMacVIVR(pR, pA, pb, d)   BiasMacVRVI (pR, pb, pA, d)
#define BiasHullVIVR(pR, pA, pb, d)  BiasHullVRVI (pR, pb, pA, d)

#if defined (__cplusplus)
}
#endif

#endif /* __BIAS1__ */
