/************************************************************************
*  Bias0IEEE.h (Basic Interval Arithmetic Subroutines Level 0)
*
*  Version:                     1.8
*  Date:                        10/1/93
*  Author:                      D. Husung, O. Knueppel
*  Interval Representation:     INFSUP
*  Interval Implementation:     IEEE
*************************************************************************/

#ifndef __BIAS0__
#define __BIAS0__

#define __BIASINFSUP__                  /* __BIASMIDRAD__               */
#define __BIASIEEE__                    /* __BIASEPS__, __BIASFAST__    */

#ifndef __PORTAB__
#include "Portab.h"
#endif

/************************************************************************
*  Definition of Constants, Types, and Variables
*************************************************************************/

#define REAL    DOUBLE
#define PREAL   PDOUBLE
#define PCREAL  PCDOUBLE

typedef struct {
  REAL          inf;
  REAL          sup;
} BIASINTERVAL;

typedef const BIASINTERVAL CBIASINTERVAL; 
typedef BIASINTERVAL FAR * PBIASINTERVAL;
typedef CBIASINTERVAL FAR * PCBIASINTERVAL;

#if defined (__cplusplus)
#define extern extern "C"
#endif

extern REAL     BiasEpsilon;            /* min {x >= 0 : 1 + x > 1}     */
extern REAL     BiasEta;                /* min {x > 0}                  */
extern REAL     BiasNaN;                /* NaN                          */
extern REAL     BiasPosInf;             /* +oo                          */
extern REAL     BiasNegInf;             /* -oo                          */

#undef extern
/************************************************************************
*  Function Prototypes
*************************************************************************/
#if defined (__cplusplus)
extern "C" {
#endif

VOID    BiasRoundUp     (VOID);
VOID    BiasRoundDown   (VOID);
VOID    BiasRoundNear   (VOID);

VOID    BiasInit        (VOID);

REAL    BiasPredR       (const PCREAL         pa);
INT     BiasPredI       (const PBIASINTERVAL pR, const PCBIASINTERVAL pA);

REAL    BiasSuccR       (const PCREAL         pa);
VOID    BiasSuccI       (const PBIASINTERVAL pR, const PCBIASINTERVAL pA);

VOID    BiasAddRR       (const PBIASINTERVAL pR,
			 const PCREAL         pa, const PCREAL         pb);
VOID    BiasAddRI       (const PBIASINTERVAL pR,
			 const PCREAL         pa, const PCBIASINTERVAL pB);
VOID    BiasAddII       (const PBIASINTERVAL pR,
			 const PCBIASINTERVAL pA, const PCBIASINTERVAL pB);

VOID    BiasSubRR       (const PBIASINTERVAL pR,
			 const PCREAL         pa, PCREAL         pb);
VOID    BiasSubRI       (const PBIASINTERVAL pR,
			 const PCREAL         pa, const PCBIASINTERVAL pB);
VOID    BiasSubIR       (const PBIASINTERVAL pR,
			 const PCBIASINTERVAL pA, const PCREAL         pb);
VOID    BiasSubII       (const PBIASINTERVAL pR,
			 const PCBIASINTERVAL pA, const PCBIASINTERVAL pB);

VOID    BiasMulRR       (const PBIASINTERVAL pR,
			 const PCREAL         pa, const PCREAL         pb);
VOID    BiasMulRI       (const PBIASINTERVAL pR,
			 const PCREAL         pa, const PCBIASINTERVAL pB);
VOID    BiasMulII       (const PBIASINTERVAL pR,
			 const PCBIASINTERVAL pA, const PCBIASINTERVAL pB);

VOID    BiasDivRR       (const PBIASINTERVAL pR,
			 const PCREAL         pa, const PCREAL         pb);
VOID    BiasDivRI       (const PBIASINTERVAL pR,
			 const PCREAL         pa, const PCBIASINTERVAL pB);
VOID    BiasDivIR       (const PBIASINTERVAL pR,
			 const PCBIASINTERVAL pA, const PCREAL         pb);
VOID    BiasDivII       (const PBIASINTERVAL pR,
			 const PCBIASINTERVAL pA, const PCBIASINTERVAL pB);

VOID    BiasMacRR       (const PBIASINTERVAL pR,
			 const PCREAL         pa, const PCREAL         pb);
VOID    BiasMacRI       (const PBIASINTERVAL pR,
			 const PCREAL         pa, const PCBIASINTERVAL pB);
VOID    BiasMacII       (const PBIASINTERVAL pR,
			 const PCBIASINTERVAL pA, const PCBIASINTERVAL pB);

/*
  REAL    BiasInf         (const PCBIASINTERVAL pA);
  REAL    BiasSub         (const PCBIASINTERVAL pA);
*/

VOID    BiasNeg         (const PBIASINTERVAL pR, const PCBIASINTERVAL pA);

REAL    BiasMid         (const PCBIASINTERVAL pA);
VOID    BiasMidRad      (const PREAL         pm, const PREAL         pr,
			 const PCBIASINTERVAL pA);
REAL    BiasDiam        (const PCBIASINTERVAL pA);

REAL    BiasAbs         (const PCBIASINTERVAL pA);

REAL    BiasDistRI      (const PCREAL         pa, const PCBIASINTERVAL pB);
REAL    BiasDistII      (const PCBIASINTERVAL pA, const PCBIASINTERVAL pB);

INT     BiasIntersection(const PBIASINTERVAL pR,
			 const PCBIASINTERVAL pA, const PCBIASINTERVAL pB);

VOID    BiasHullR       (const PBIASINTERVAL pR, const PCREAL         pa);
VOID    BiasHullRR      (const PBIASINTERVAL pR,
			 const PCREAL         pa, const PCREAL         pb);
VOID    BiasHullRI      (const PBIASINTERVAL pR,
			 const PCREAL         pa, const PCBIASINTERVAL pB);
VOID    BiasHullII      (const PBIASINTERVAL pR,
			 const PCBIASINTERVAL pA, const PCBIASINTERVAL pB);

INT     BiasInR         (const PCREAL         pa, const PCBIASINTERVAL pB);
INT     BiasInI         (const PCBIASINTERVAL pA, const PCBIASINTERVAL pB);

INT     BiasInInteriorR (const PCREAL         pa, const PCBIASINTERVAL pB);
INT     BiasInInteriorI (const PCBIASINTERVAL pA, const PCBIASINTERVAL pB);

INT     BiasIsEqual     (const PCBIASINTERVAL pA, const PCBIASINTERVAL pB);

#define BiasInf(pA)     ((pA)->inf)
#define BiasSup(pA)     ((pA)->sup)

#define BiasAddIR(pR, pA, pb)    BiasAddRI (pR, pb, pA)
#define BiasMulIR(pR, pA, pb)    BiasMulRI (pR, pb, pA)
#define BiasMacIR(pR, pA, pb)    BiasMacRI (pR, pb, pA)
#define BiasDistIR(pA, pb)       BiasDistRI (pb, pA)
#define BiasHullIR(pR, pA, pb)   BiasHullRI (pR, pb, pA)

#if defined (__cplusplus)
}
#endif

#endif /* __BIAS0__ */
